#!/bin/bash
lescript=`basename $0 .sh`
flag=$TMP_PATH/bot_$lescript.flag

#
#  TOOLS
#
function debug
{
  if [ -f $FLAG_PATH/debug ]
  then
    echo $1
  fi
}

function sortie
{
  if [ -f $flag ]
  then
    rm -f $flag
  fi
  exit $1
}

function succes
{
  debug "SUCCES"
  sortie 0
}

function echec
{
  debug "ECHEC"
  sortie 1
}

#
# TEST DU FLAG
#
if [ -f $flag ]
then
  debug "$0 is already running !"
  exit 1
fi
touch $flag

#
# PARAMETRES PAR FICHIER FLAGS
#
if [ -f $FLAG_PATH/no_tweet ]
then
  debug "No Tweet"
  echec
fi

if [ ! -d $DATA_PATH/twitterbot ]
then
  mkdir -p $DATA_PATH/twitterbot
fi

if [ ! -d $DATA_PATH/emptybot ]
then
  mkdir -p $DATA_PATH/emptybot
fi

#
# TWEET
#

# tweet Topisto : empty blocks
$APPS_PATH/twitter/emptybot/robot.sh 2>&1

# tweet frequency : 2 Hours
#TWEETFREQ=7200
#if [ $((TS % $TWEETFREQ)) -eq 0 ]
# Tweet freq : One per Hour
if [ ! -f $DATA_PATH/twitterbot/$DATEHOUR ]
then
  debug "send a TWEET"

  # tweet R. Topisto
  $APPS_PATH/twitter/twitterbot/robot.sh 2>&1

  # "auto likes" from Topisto
  # $APPS_PATH/twitter/likebot/robot.sh 2>&1

  touch $DATA_PATH/twitterbot/$DATEHOUR
else
  debug "skip TWEET"
fi

#
# SORTIE AVEC SUCCES
#
succes
