#!/bin/bash
lescript=`basename $0 .sh`

#
#  TOOLS
#
function debug
{
  if [ -f $FLAG_PATH/debug ]
  then
    echo $1
  fi
}

function sortie
{
  exit $1
}

function succes
{
  debug "SUCCES"
  sortie 0
}

function echec
{
  debug "ECHEC"
  exit 1
}

#
# PARAMETRES PAR FICHIER FLAGS
#
if [ -f $FLAG_PATH/no_blocks ]
then
  debug "No blocks"
  echec
fi

while IFS='' read -r line || [[ -n "$line" ]]; do

  NAME=`echo $line | awk '{print $1}'`
  BLOCK=`echo $line | awk '{print $2}'`
  HEIGHT=`echo $line | awk '{print $3}'`
  NBTX=`echo $line | awk '{print $4}'`

  #
  # TEST DU FLAG
  #
  flag=$FLAG_PATH/bot_${lescript}_${BLOCK}.flag
  if [ -f $flag ]
  then
    debug "${lescript}_${BLOCK} already done"
    continue
  fi
  touch $flag

  if [ ! -f $DATA_PATH/nonce/$BLOCK.png ]
  then
    echo "Aucune image pour nonce !"
  fi

  rm -f $flag

done < $DATA_PATH/block_list.txt

#
# SORTIE AVEC SUCCES
#
succes
