#!/bin/bash
lescript=`basename $0 .sh`

#
#  TOOLS
#
function debug
{
  if [ -f $FLAG_PATH/debug ]
  then
    echo $1
  fi
}

function sortie
{
  exit $1
}

function succes
{
  debug "SUCCES"
  sortie 0
}

function echec
{
  debug "ECHEC"
  exit 1
}

#
# PARAMETRES PAR FICHIER FLAGS
#
if [ -f $FLAG_PATH/no_blocks ]
then
  debug "No blocks"
  echec
fi

while IFS='' read -r line || [[ -n "$line" ]]; do

  NAME=`echo $line | awk '{print $1}'`
  BLOCK=`echo $line | awk '{print $2}'`
  HEIGHT=`echo $line | awk '{print $3}'`
  NBTX=`echo $line | awk '{print $4}'`

  #
  # TEST DU FLAG
  #
  flag=$FLAG_PATH/bot_${lescript}_${BLOCK}.flag
  if [ -f $flag ]
  then
    debug "${lescript}_${BLOCK} already done"
    continue
  fi
  touch $flag

  if [ ! -f $DATA_PATH/nonce/$BLOCK.png ]
  then
    #
    # Si c'est la première fois que l'on dessine le block
    # On choisit la méthode qui découle du nonce
    #
    cd $APPS_PATH/nonce
    nbmethodes=`cat $DATA_PATH/nonce_methods_list.txt | wc -l`
    lenonce=`php robot.php $BLOCK`
    lamethode=$((lenonce % nbmethodes))
    if [ $lamethode -eq 0 ]
    then
      lamethode=$nbmethodes
    fi
    LISTE_METHODE=`cat $DATA_PATH/nonce_methods_list.txt | head -n $lamethode | tail -1`
  else
    #
    # CHOISIR UNE METHODE2 AU HASARD
    #
    LISTE_METHODE=`ls $APPS_PATH/methode2 | grep -v robot | shuf | head -n 1`
  fi

  cd $APPS_PATH/methode2
  for METHODE in $LISTE_METHODE
  do
    if [ ! -d $DATA_PATH/$METHODE ]
    then
      mkdir -p $DATA_PATH/$METHODE
    fi
    echo $BLOCK $NAME $METHODE
    if [ ! -f $DATA_PATH/$METHODE/$BLOCK.png ]
    then
      php robot.php $METHODE $BLOCK $((RANDOM % 6)) $2
      cp $DATA_PATH/last/$BLOCK.png $DATA_PATH/$METHODE/$BLOCK.png
      cp $DATA_PATH/last/$BLOCK.png $DATA_PATH/hasard/$BLOCK.png
    fi
  done
  cd - >> /dev/null

  if [ ! -f $DATA_PATH/nonce/$BLOCK.png ]
  then
    cp $DATA_PATH/last/$BLOCK.png $DATA_PATH/nonce/$BLOCK.png
  fi

  rm -f $flag

done < $DATA_PATH/block_list.txt

#
# List of finished blocks
#
rm -f $DATA_PATH/finished_block_list.txt
grep -v CACHE $DATA_PATH/block_list.txt >> $DATA_PATH/finished_block_list.txt

#
# SORTIE AVEC SUCCES
#
succes
