#!/bin/bash
lescript=`basename $0 .sh`
flag=$TMP_PATH/bot_$lescript.flag

#
#  TOOLS
#
function debug
{
  if [ -f $FLAG_PATH/debug ]
  then
    echo $1
  fi
}

function sortie
{
  if [ -f $flag ]
  then
    rm -f $flag
  fi
  exit $1
}

function succes
{
  debug "SUCCES"
  sortie 0
}

function echec
{
  debug "ECHEC"
  exit 1
}

#
# TEST DU FLAG
#
if [ -f $flag ]
then
  debug "$0 is already running !"
  echec
fi
touch $flag

#
# PARAMETRES PAR FICHIER FLAGS
#
if [ -f $FLAG_PATH/no_blocks ]
then
  debug "No blocks"
  echec
fi

#
# CHOISIR UNE METHODE2 AU HASARD
#
ROBOT=`ls $APPS_PATH/methode2 | shuf | tail -n 1`
debug $ROBOT

$APPS_PATH/methode2/robot.sh $ROBOT

succes

#
# CHOISIR UNE METHODE AU HASARD
#
ROBOT=`ls $APPS_PATH/methode | grep -v hashes | shuf | tail -n 1`
debug $ROBOT

#
# Y A PLUS QU'A !
#
if [ ! -f $FLAG_PATH/no_$ROBOT ]
then
  cd $APPS_PATH/methode/$ROBOT
  for BLOCK in `awk '{print $2}' $DATA_PATH/block_list.txt`
  do
  
    #
    # Pour renouveller l'affichage des blocs remarquables
    #   De temps en temps (15%), on efface le block
    #
    if [ $((RANDOM % 100)) -lt 15 ]
    then
      rm -f $DATA_PATH/$ROBOT/$BLOCK.png
    fi

    #
    # Si l'image n'existe pas, on la calcule
    #
    if [ ! -f $DATA_PATH/$ROBOT/$BLOCK.png ]
    then
      debug "Compute $DATA_PATH/$ROBOT/$BLOCK.png"
      php robot.php $BLOCK
    fi

    #
    # Les actions suivantes ne sont réalisées que si
    #      robot.php a produit une image
    #
    if [ -f $DATA_PATH/$ROBOT/$BLOCK.png ]
    then
      #
      # Les blocs remarquables sont anti datés à minuit
      #  Pour l'affichage et le nettoyage automatique 
      #
      BNAME=`grep $BLOCK $DATA_PATH/block_list.txt | awk '{print $1}'`
      if [ "$BNAME" != "LAST" ]
      then
        touch -t $DATE $DATA_PATH/$ROBOT/$BLOCK.png
        if [ -f $DATA_PATH/spline/$BLOCK.png ]
        then
          rm -f $DATA_PATH/hasard/$BLOCK.png
          ln $DATA_PATH/spline/$BLOCK.png $DATA_PATH/hasard/$BLOCK.png
        fi
      fi

      #
      # Maintenir le hasard
      #
      if [ ! -f $DATA_PATH/hasard/$BLOCK.png ]
      then
        ln $DATA_PATH/$ROBOT/$BLOCK.png $DATA_PATH/hasard/$BLOCK.png
      fi
    fi
  done
fi

#
# List of finished blocks
#
rm -f $DATA_PATH/finished_block_list.txt
grep -v CACHE $DATA_PATH/block_list.txt >> $DATA_PATH/finished_block_list.txt

#
# SORTIE AVEC SUCCES
#
succes
