#!/bin/bash
lescript=`basename $0 .sh`

#
#  TOOLS
#
function debug
{
  if [ -f $FLAG_PATH/debug ]
  then
    echo $1
  fi
}

function sortie
{
  exit $1
}

function succes
{
  debug "SUCCES"
  sortie 0
}

function echec
{
  debug "ECHEC"
  exit 1
}

#
# PARAMETRES PAR FICHIER FLAGS
#
if [ -f $FLAG_PATH/no_blocks ]
then
  debug "No blocks"
  echec
fi

BLOCK=`grep LAST $DATA_PATH/block_list.txt | awk '{print $2}'`
echo $BLOCK

cd $APPS_PATH/info
infos=`php robot.php $BLOCK`
HEIGHT=`echo $infos | awk '{print $1}'`
TIMETS=`echo $infos | awk '{print $2}'`
NBTX=`echo $infos | awk '{print $3}'`
NONCE=`echo $infos | awk '{print $4}'`
PREV=`echo $infos | awk '{print $5}'`

#
# TEST DU FLAG
#
flag=$FLAG_PATH/bot_${lescript}_${BLOCK}.flag
if [ -f $flag ]
then
  debug "${lescript}_${BLOCK} already done"
fi
touch $flag

LISTE_METHODE=`ls $APPS_PATH/methode2 | grep -v robot | shuf`

cd $APPS_PATH/methode2
for METHODE in $LISTE_METHODE
do
  if [ ! -d $DATA_PATH/$METHODE ]
  then
    mkdir -p $DATA_PATH/$METHODE
  fi
  echo $BLOCK $NAME $METHODE
  if [ ! -f $DATA_PATH/$METHODE/$BLOCK.png ]
  then
    php robot.php $METHODE $BLOCK $((RANDOM % 6)) $2
    cp $DATA_PATH/last/$BLOCK.png $DATA_PATH/$METHODE/$BLOCK.png
    cp $DATA_PATH/last/$BLOCK.png $DATA_PATH/hasard/$BLOCK.png
  fi
done
cd - >> /dev/null

cp $DATA_PATH/last/$BLOCK.png $DATA_PATH/nonce/$BLOCK.png

#
# SORTIE AVEC SUCCES
#
succes
