<?php

use codeagent\treemap\Treemap;
use codeagent\treemap\presenter\ImagePresenter;
use codeagent\treemap\presenter\NodeInfo;
use codeagent\treemap\Gradient;

function DrawBlock($the_block, $vImage, $parametres)
{
  $type    = 1;

  if (isset($parametres['x']))                $x       = $parametres['x'];
  if (isset($parametres['y']))                $y       = $parametres['y'];
  if (isset($parametres['width']))            $width   = $parametres['width'];
  if (isset($parametres['height']))           $height  = $parametres['height'];
  if (isset($parametres['methode']))          $mode    = $parametres['methode'];
  if (isset($parametres['type']))             $type    = $parametres['type'];
  if (isset($parametres['font_color']))       $vFgColor   = $parametres['font_color'];
  if (isset($parametres['background_color'])) $vBgColor   = $parametres['background_color'];
  if (isset($parametres['font_RGB']))         $vFgRGB   = $parametres['font_RGB'];
  if (isset($parametres['background_RGB']))   $vBgRGB   = $parametres['background_RGB'];

  $min  =-1;
  $max  = 0;
  $data = blockchain::getTransactionData($the_block, $type);

  // Inverser foreground et Background
  imagefilledrectangle($vImage, $x, $y, $x+$width, $y+$height, $vFgColor);
  $vFgColor = imagecolorallocatealpha($vImage, $vBgRGB[0], $vBgRGB[1], $vBgRGB[2], 125);
  //$vBgColor = imagecolorallocate($vImage, 10, 10, 10);
  //imagefilledrectangle($vImage, $x, $y, $x+$width, $y+$height, $vBgColor);

  // Calcul des min max
  foreach($data as $v)
  {
    if ($v['value'] > $max) $max = $v['value'];
    if (($v['value'] < $min)||($min == -1)) $min = $v['value'];
  }
  if ($min == $max) $max = $min + 1;

  $treemap = new Treemap($data, $width, $height);
  $map = $treemap->getMap();
  $mm = count($map);
  $mmax = $mm - 30;
  foreach($map as $tx)
  {
    $x1 = $x + $tx['_rectangle']->left;
    $y1 = $y + $tx['_rectangle']->top;

    if (($tx['_rectangle']->height < 2)&&($tx['_rectangle']->width < 2))
    {
    	imagesetpixel($vImage, $x1, $y1, $vFgColor);
    } else {
    	$x2 = $x1;
    	$y2 = $y1 + $tx['_rectangle']->height;
    	// if ($y2 >= ($height-$bandeau)) $y2 = ($height - $bandeau) - 1;

    	$x3 = $x1 + $tx['_rectangle']->width;
    	$y3 = $y2;

    	$x4 = $x3;
    	$y4 = $y1;

    	// ----
    	$w = floor($tx['_rectangle']->width / 4);
    	$h = floor($tx['_rectangle']->height / 4);

    	$ww = floor(200*($mm/$mmax));
      $ww = floor(($h * $w)*0.8);
      if ($ww < 1) $ww = 1;
    	for($i=0;$i<$ww;$i++)
    	{
    	  $x1_1 = $x1 + floor($w*( rand(0, 100) / 100));
    	  $y1_1 = $y1 + floor($h*( rand(0, 100) / 100));

        $x2_1 = $x2 + floor($w*( rand(0, 100) / 100));
        $y2_1 = $y2 - floor($h*( rand(0, 100) / 100));

        $x3_1 = $x3 - floor($w*( rand(0, 100) / 100));
        $y3_1 = $y3 - floor($h*( rand(0, 100) / 100));

        $x4_1 = $x4 - floor($w*( rand(0, 100) / 100));
        $y4_1 = $y4 + floor($h*( rand(0, 100) / 100));

    	  imageline($vImage, $x1_1, $y1_1, $x2_1, $y2_1, $vFgColor);
    	  imageline($vImage, $x2_1, $y2_1, $x3_1, $y3_1, $vFgColor);
    	  imageline($vImage, $x3_1, $y3_1, $x4_1, $y4_1, $vFgColor);
    	  imageline($vImage, $x4_1, $y4_1, $x1_1, $y1_1, $vFgColor);
    	}
    }
    $mm -= 1;
  }
}

?>
