<?php

function DrawBlock($the_block, $vImage, $parametres)
{
  // valeurs par défaut
  $type   = 1;

  // Ces variables vont permettre de caler les lignes
  // dans la zone de dessin en se laissant des marges
  // en haut et en bas
  $somme   = 0;
  $min     =-1;
  $max     = 0;
  $marge_x = 10;
  $marge_y = 10;
  $facteur_max = 2.5;

  // Détermine si on dessine les tx, les fees ou la récompense
  if (isset($parametres['type']))             $type    = $parametres['type'];

  // Paramètres de dessin
  if (isset($parametres['x']))                $x        = $parametres['x'];
  if (isset($parametres['y']))                $y        = $parametres['y'];
  if (isset($parametres['width']))            $width    = $parametres['width'];
  if (isset($parametres['height']))           $height   = $parametres['height'];
  if (isset($parametres['font_color']))       $vFgColor = $parametres['font_color'];
  if (isset($parametres['background_color'])) $vBgColor = $parametres['background_color'];
  if (isset($parametres['font_RGB']))         $vFgRGB   = $parametres['font_RGB'];
  if (isset($parametres['background_RGB']))   $vBgRGB   = $parametres['background_RGB'];

  $fondRGB=[234,220,207];
  $couleursRGB=[
    [197,46,39],
    [183,230,214],
    [248,200,40],
    [51,41,32],
    [250,142,41],
    [5,37,32],
    [233,201,58],
    [183,230,214]
  ];

  shuffle($couleursRGB);

  $pas = $height / (count($couleursRGB)-1);

  $img_w = $width;
  $img_h = $height+(2*$y);

  // Redessiner entête et pied de page
  $p2 = blockchain::DrawBlockHeaderFooter($the_block, $vImage, $y, 8);
  $fond=imagecolorallocate($vImage,$fondRGB[0],$fondRGB[1],$fondRGB[2]);

  // Remplir le fond
  imagefilledrectangle($vImage, 0, $y, $width, $y + $height, $fond);
  // Tracer des bords à droite et à gauche
  imageline($vImage, 0, 5, 0, $img_h-25, $p2[2]);
  imageline($vImage, $width-1, 5, $width-1, $img_h-25, $p2[2]);

  // Récup des données
  $data = blockchain::getTransactionData($the_block, $type);
  $n_data = count($data);

  // Un calculateur de Spline
  $oCurve = new CubicSplines();

  // Calcul des min max
  foreach($data as $v)
  {
    if ($v['value'] > $max) $max = $v['value'];
    if (($v['value'] < $min)||($min == -1)) $min = $v['value'];
    $somme += $v['value'];
  }
  if ($min == $max) $max = $min + 1;
  if ($somme == 0) return;

  // On se prend une plus grosse marge en hauteur
  $coef     = ($height - (4*$marge_y)) / $somme;
  $limite_x = $x + ($width - (2*$marge_x));
  $dx       = round(($width - (2*$marge_x)) / (TX_HASH_LEN+10));

  $h0 = 0;
  $hauteur = $y + (2*$marge_y);
  $special_draw = (count($data) == 1);
  $etage = -1;

  // [ TODO ] L'épaisseur du trait dépend du nombre de transactions
  $epaisseur = 5;

  foreach($data as $transaction)
  {
    //
    // La nouvelle hauteur : cumule des montants de transaction
    //
    $hauteur += $coef * $transaction['value'];

    //
    // Gestion de la couleur
    //
    if ($etage != floor($hauteur/$pas))
    {
      $etage = floor($hauteur/$pas);

      $vColor    = array();
      // Dégradé de 192 couleurs entre la couleur de dessin et le blanc
      $nb_colors = 192;
      $hex_val   = array(
        ColorGradient::rgb2hex($couleursRGB[$etage]),
        ColorGradient::rgb2hex([255,255,255])
      );
      $gradient = ColorGradient::gradient($hex_val[0], $hex_val[1], $nb_colors);
      for($i=0;$i<$nb_colors;$i++)
      {
        $rgbval = ColorGradient::hex2rgb($gradient[$i]);
        // Pas de blanc <=> c'est la transparence ...
        if (($rgbval[0] == $rgbval[1])&&($rgbval[1] == $rgbval[2])&&($rgbval[0] > 252))
        {
          $rgbval[0] = 255;
          $rgbval[1] = 255;
          $rgbval[2] = 255;
        }
        $vColor[$i] = new ColorGradient();
        $vColor[$i]->pct   = ($i*1.0) / 256;
        $vColor[$i]->color = imagecolorallocate($vImage, $rgbval[0], $rgbval[1], $rgbval[2]);
      }
      // On ajoute un dégradé de 64 couleurs entre le blanc et la couleur de fond
      $nb_colors = 64;
      $hex_val   = array(
        ColorGradient::rgb2hex([255,255,255]),
        ColorGradient::rgb2hex($fondRGB)
      );
      $gradient = ColorGradient::gradient($hex_val[0], $hex_val[1], $nb_colors);
      for($i=0;$i<$nb_colors;$i++)
      {
        $rgbval = ColorGradient::hex2rgb($gradient[$i]);
        // Pas de blanc <=> c'est la transparence ...
        if (($rgbval[0] == $rgbval[1])&&($rgbval[1] == $rgbval[2])&&($rgbval[0] > 252))
        {
          $rgbval[0] = 255;
          $rgbval[1] = 255;
          $rgbval[2] = 255;
        }
        $vColor[192+$i] = new ColorGradient();
        $vColor[192+$i]->pct   = ((192+$i)*1.0) / 256;
        $vColor[192+$i]->color = imagecolorallocate($vImage, $rgbval[0], $rgbval[1], $rgbval[2]);
      }
      $nb_colors = 256;    
    }

    //
    // Cas des blocks qui n'ont qu'une seule transaction
    //             On se cale au milieu
    // 
    if ($special_draw) $hauteur = $y + ($height / 2);

    //
    // Ne pas tracer 2 lignes à la même hauteur
    //   => c'est possible du fait de l'arrondi
    //      si la transaction a un montant faible
    //
    if ((floor($hauteur)-$h0)<2) continue;
    $h0 = floor($hauteur);

    $x0 = $x + $marge_x;

    //
    // On découpe la ligne en fonction du nombre de DIGIT 
    //         dans le hash des transactions
    //
    $facteur      = 0.1;
    $aCoords      = array();
    $aCoords[$x0] = $h0; $x0 += $dx;
    $aCoords[$x0] = $h0; $x0 += $dx;
    $aCoords[$x0] = $h0; $x0 += $dx;
    $aCoords[$x0] = $h0; $x0 += $dx;
    $aCoords[$x0] = $h0; $x0 += $dx;
    $aCoords[$x0] = $h0; $x0 += $dx;
    $aCoords[$x0] = $h0; $x0 += $dx;
    $aCoords[$x0] = $h0; $x0 += $dx;
    $aCoords[$x0] = $h0; $x0 += $dx;
    $aCoords[$x0] = $h0; $x0 += $dx;
    for ($i = 0; $i < TX_HASH_LEN; $i++) 
    {
      $y0 = $h0;
      $valeur = hexdec($transaction['hash'][$i]);
      if ($valeur != 0) $y0 += floor(($valeur - 8) * $facteur);
      $x0 += $dx;
      $aCoords[$x0] = $y0;

      if ($y0 == $h0) continue;

      $facteur = 0.1 + (($facteur_max*$i) / TX_HASH_LEN);
      if ($facteur > $facteur_max) $facteur = $facteur_max;
    }

    for($i=0;$i<$epaisseur;$i++) 
    {
      foreach($aCoords as &$aCoord)
      {
        $aCoord += 1;
        if ($aCoord < $y+$marge_y)           $aCoord = $y+$marge_y;
        if ($aCoord > ($y+$height-$marge_y)) $aCoord = $y+$height-$marge_y;
      }

      $oCurve->setInitCoords($aCoords);
      $r = $oCurve->processCoords();
      if ($r)
      {
        $curveGraph = new Plot($r);
        $curveGraph->drawLine($vImage, $vColor, $x0, $limite_x);
      }
    }
  }
}

?>
