<?php

use codeagent\treemap\Treemap;
use codeagent\treemap\presenter\ImagePresenter;
use codeagent\treemap\presenter\NodeInfo;

function DrawBlock($the_block, $vImage, $parametres)
{
  $type    = 1;

  if (isset($parametres['x']))                $x       = $parametres['x'];
  if (isset($parametres['y']))                $y       = $parametres['y'];
  if (isset($parametres['width']))            $width   = $parametres['width'];
  if (isset($parametres['height']))           $height  = $parametres['height'];
  if (isset($parametres['methode']))          $mode    = $parametres['methode'];
  if (isset($parametres['type']))             $type    = $parametres['type'];
  if (isset($parametres['font_color']))       $vBgColor   = $parametres['font_color'];
  if (isset($parametres['background_color'])) $vFgColor   = $parametres['background_color'];

  imagefilledrectangle($vImage, $x, $y, $x+$width, $y+$height, $vFgColor);

  $full_area = $width * $height;
  if ($full_area == 0) $full_area = 1;

  $data = blockchain::getTransactionData($the_block, $type);

  $treemap = new Treemap($data, $width, $height);
  $map = $treemap->getMap();
  $m = count($map);
  $flag_contour = true;
  for($mm = 0; $mm < $m; $mm++)
  {
    $tx     = $map[$mm];
    $factor = (($tx['_rectangle']->width * $tx['_rectangle']->height) / $full_area)*100.0;

    $x1 = $x + $tx['_rectangle']->left;
    $y1 = $y + $tx['_rectangle']->top;

    $x2 = $x1 + $tx['_rectangle']->width;
    $y2 = $y1 + $tx['_rectangle']->height;

    if ($x1 > ($x+$width))  $x1 = ($x+$width);
    if ($y1 > ($y+$height)) $y1 = ($y+$height);
    if ($x2 > ($x+$width))  $x2 = ($x+$width);
    if ($y2 > ($y+$height)) $y2 = ($y+$height);

    if (($x2 - $x1) < 3) break;
    if (($y2 - $y1) < 3) break;

    imagerectangle($vImage, $x1, $y1, $x2, $y2, $vBgColor);
  }
  if ($mm < $m) imagerectangle($vImage, $x1, $y1, $x+$width, $y+$height, $vBgColor);
}

?>
