<?php

function DrawBlock($the_block, $vImage, $parametres)
{
  // valeurs par défaut
  $type   = 1;

  // Ces variables vont permettre de caler les lignes
  // dans la zone de dessin en se laissant des marges
  // en haut et en bas
  $somme   = 0;
  $min     =-1;
  $max     = 0;
  $marge_x = 10;
  $marge_y = 10;
  $facteur_max = 2.5;

  $local_iterations = 100;

  // Détermine si on dessine les tx, les fees ou la récompense
  if (isset($parametres['type']))             $type    = $parametres['type'];

  // Paramètres de dessin
  if (isset($parametres['x']))                $x        = $parametres['x'];
  if (isset($parametres['y']))                $y        = $parametres['y'];
  if (isset($parametres['width']))            $width    = $parametres['width'];
  if (isset($parametres['height']))           $height   = $parametres['height'];
  if (isset($parametres['font_color']))       $vFgColor = $parametres['font_color'];
  if (isset($parametres['background_color'])) $vBgColor = $parametres['background_color'];
  if (isset($parametres['font_RGB']))         $vFgRGB   = $parametres['font_RGB'];
  if (isset($parametres['background_RGB']))   $vBgRGB   = $parametres['background_RGB'];

  if (isset($parametres['iterations']))       $local_iterations = $parametres['iterations'];

  $facteur_max = 2.5 * ($height / GRAPH_HEIGHT);

  $fondRGB=[0,0,0];
  $fond=imagecolorallocate($vImage,$fondRGB[0],$fondRGB[1],$fondRGB[2]);
  $couleurRGB=[240,147,43];

  // Remplir le fond
  imagefilledrectangle($vImage, $x+($marge_x/2), $y+($marge_y/2), $x+$width-+($marge_x/2), $y+$height-+($marge_y/2), $fond);

  // Dégradé de 192 couleurs entre la couleur de dessin et le blanc
  $alpha     = 100;
  $vColor    = array();
  $nb_colors = 192;
  $hex_val   = array(
    ColorGradient::rgb2hex($couleurRGB),
    ColorGradient::rgb2hex([255,255,255])
  );
  $gradient = ColorGradient::gradient($hex_val[0], $hex_val[1], $nb_colors);
  for($i=0;$i<$nb_colors;$i++)
  {
    $rgbval = ColorGradient::hex2rgb($gradient[$i]);
    $vColor[$i] = new ColorGradient();
    $vColor[$i]->pct   = ($i*1.0) / 256;
    $vColor[$i]->color = imagecolorallocatealpha($vImage, $rgbval[0], $rgbval[1], $rgbval[2], $alpha);
  }
  // On ajoute un dégradé de 64 couleurs entre le blanc et la couleur de fond
  $nb_colors = 64;
  $hex_val   = array(
    ColorGradient::rgb2hex([255,255,255]),
    ColorGradient::rgb2hex($fondRGB)
  );
  $gradient = ColorGradient::gradient($hex_val[0], $hex_val[1], $nb_colors);
  for($i=0;$i<$nb_colors;$i++)
  {
    $rgbval = ColorGradient::hex2rgb($gradient[$i]);
    $vColor[192+$i] = new ColorGradient();
    $vColor[192+$i]->pct   = ((192+$i)*1.0) / 256;
    $vColor[192+$i]->color = imagecolorallocatealpha($vImage, $rgbval[0], $rgbval[1], $rgbval[2], $alpha);
  }
  $nb_colors = 256;

  // Récup des données
  $data = blockchain::getTransactionData($the_block, $type);
  $n_data = count($data);

  // --- 
  // --- On se limite à 40 000 traits
  // ---    Pour des questions de performance
  // ---
  while(($n_data * $local_iterations)>40000) $local_iterations--;

  // Un calculateur de Spline
  $oCurve = new CubicSplines();

  // Calcul des min max
  foreach($data as $v)
  {
    if ($v['value'] > $max) $max = $v['value'];
    if (($v['value'] < $min)||($min == -1)) $min = $v['value'];
    $somme += $v['value'];
  }
  if ($min == $max) $max = $min + 1;
  if ($somme == 0) return;

  // On se prend une plus grosse marge en hauteur
  $coef     = ($height - (4*$marge_y)) / $somme;
  $limite_x = $x + ($width - (2*$marge_x));
  $dx       = round(($width - (2*$marge_x)) / (TX_HASH_LEN+10));

  $special_draw = (count($data) == 1);

  while($local_iterations-- > 0)
  {
    $h0 = 0;
    $hauteur = $y + (2*$marge_y);

    foreach($data as $transaction)
    {
      //
      // La nouvelle hauteur : cumule des montants de transaction
      //
      $hauteur += $coef * $transaction['value'];
  
      //
      // Cas des blocks qui n'ont qu'une seule transaction
      //             On se cale au milieu
      // 
      if ($special_draw) $hauteur = $y + ($height / 2);
  
      //
      // Ne pas tracer 2 lignes à la même hauteur
      //   => c'est possible du fait de l'arrondi
      //      si la transaction a un montant faible
      //
      if ((floor($hauteur)-$h0)<2) continue;
      $h0 = floor($hauteur);
  
      $x0 = $x + $marge_x;
  
      //
      // On découpe la ligne en fonction du nombre de DIGIT 
      //         dans le hash des transactions
      //
      $facteur      = 0.1;
      $aCoords      = array();
      $aCoords[$x0] = $h0; $x0 += $dx;
      $aCoords[$x0] = $h0; $x0 += $dx;
      $aCoords[$x0] = $h0; $x0 += $dx;
      $aCoords[$x0] = $h0; $x0 += $dx;
      $aCoords[$x0] = $h0; $x0 += $dx;
      $aCoords[$x0] = $h0; $x0 += $dx;
      $aCoords[$x0] = $h0; $x0 += $dx;
      $aCoords[$x0] = $h0; $x0 += $dx;
      $aCoords[$x0] = $h0; $x0 += $dx;
      $aCoords[$x0] = $h0; $x0 += $dx;
      for ($i = 0; $i < TX_HASH_LEN; $i++) 
      {
        $y0 = $h0;
        $valeur = hexdec($transaction['hash'][$i]);
        if ($valeur != 0) 
        {
          $decal  = 15.0 * ($i / TX_HASH_LEN);
          $valeur += rand(0, floor($decal));
          $valeur /= 2;
          $valeur -= 8;
          $y0 = $h0 + ($valeur * $facteur);
        }

        if ($y0 < $y+$marge_y) $y0 = $y+$marge_y;
        if ($y0 > ($y+$height-$marge_y)) $y0 = $y+$height-$marge_y;
        $x0 += $dx;
        $aCoords[$x0] = $y0;

        if ($y0 == $h0) continue;

        $facteur = 0.1 + (($facteur_max*$i) / TX_HASH_LEN);
        if ($facteur > $facteur_max) $facteur = $facteur_max;
      }
      if ($oCurve) 
      {
        $oCurve->setInitCoords($aCoords);
        $r = $oCurve->processCoords();
        if ($r)
        {
          $curveGraph = new Plot($r);
          $curveGraph->drawLine($vImage, $vColor, $x0, $limite_x);
        }
      }
    }  
  }
}

?>
