<?php

function DrawBlock($the_block, $vImage, $parametres)
{
  // valeurs par défaut
  $type   = 1;

  // Ces variables vont permettre de caler les lignes
  // dans la zone de dessin en se laissant des marges
  // en haut et en bas
  $somme       = 0;
  $min         =-1;
  $max         = 0;
  $marge_x     = 10;
  $marge_y     = 10;
  $facteur_max = 2.5;
  $alpha       = 0; 

  // Détermine si on dessine les tx, les fees ou la récompense
  if (isset($parametres['type']))             $type    = $parametres['type'];

  // Paramètres de dessin
  if (isset($parametres['x']))                $x        = $parametres['x'];
  if (isset($parametres['y']))                $y        = $parametres['y'];
  if (isset($parametres['width']))            $width    = $parametres['width'];
  if (isset($parametres['height']))           $height   = $parametres['height'];
  if (isset($parametres['font_color']))       $vFgColor = $parametres['font_color'];
  if (isset($parametres['background_color'])) $vBgColor = $parametres['background_color'];
  if (isset($parametres['font_RGB']))         $vFgRGB   = $parametres['font_RGB'];
  if (isset($parametres['background_RGB']))   $vBgRGB   = $parametres['background_RGB'];

  // Je reprends les couleurs de Tyler Hobbs
  $couleursRGB=[
    [234,220,207],
    [197,46,39],
    [183,230,214],
    [248,200,40],
    [51,41,32],
    [250,142,41],
    [5,37,32],
    [233,201,58],
    [183,230,214]
  ];
  $couleurs = [];
  $nb_couleurs = count($couleursRGB);
  for($i=0;$i<$nb_couleurs;$i++) 
    $couleurs[$i] = imagecolorallocate($vImage,$couleursRGB[$i][0],$couleursRGB[$i][1],$couleursRGB[$i][2]);

  // Prendre une des couleurs au hasard comme couleur de fond
  shuffle($couleurs);
  $fond = $couleurs[0];
  shuffle($couleurs);

  // Remplir le fond
  imagefilledrectangle($vImage, $x+($marge_x/2), $y+($marge_y/2), $x+$width-+($marge_x/2), $y+$height-+($marge_y/2), $fond);

  // Récup des données
  $data = blockchain::getTransactionData($the_block, $type);
  $n_data = count($data);

  // Calcul des min max
  foreach($data as $v)
  {
    if ($v['value'] > $max) $max = $v['value'];
    if (($v['value'] < $min)||($min == -1)) $min = $v['value'];
    $somme += $v['value'];
  }
  if ($min == $max) $max = $min + 1;
  if ($somme == 0) return;
  
  // On commence au centre de l'image
  $xc = $x + ($width / 2);
  $yc = $y + ($height / 2);
  $r =  $width / 3;
  $cur = 0;
  $n = 0;
  $x1 = $xc;
  $y1 = $yc;
  $x2 = $xc;
  $y2 = $yc;

  // Trouver le max
  $max=0;
  while(true){
    $r1 = 0.05 * $max;
    $x2 = $xc + $r1*cos($r1);
    $y2 = $yc + $r1*sin($r1);
    if (($x2 > $width)  || ($x2 < 0)) break;
    if (($y2 > $height) || ($y2 < 0)) break;
    imageline($vImage, $x1, $y1, $x2, $y2, $couleurs[0]);
    $x1 = $x2;
    $y1 = $y2;
    $max++;
  }
  $coef = floatval($max) / floatval($somme);

  $cur = 0;
  $n = 0;
  $x1 = $xc;
  $y1 = $yc;
  $x2 = $xc;
  $y2 = $yc;

  foreach($data as $transaction)
  {
    // chaque fois que toutes les couleurs ont été utilisées
    //              on mélange leur ordre
    if (!($n%$nb_couleurs)) shuffle($couleurs);
    // S'il n'y a qu'une transaction
    // Ou Si la transaction courante représente plus du 5eme de la somme des tx
    // On s'interdit la couleur de fond
    if (($n_data == 1)||($transaction['value'] > ($somme/5)))
      while ($couleurs[$n%$nb_couleurs] == $fond) $n++;
    $couleur = $couleurs[$n%$nb_couleurs];

    // le segment de couleur est de longueur proportionnelle
    // à la valeur de sa transaction
    $next = $cur + ($coef*$transaction['value']);
    if ($next > $max) $next = $max;

    while($cur<$next)
    {
      $r1 = 0.05 * $cur;
      $x2 = $xc + $r1*cos($r1);
      $y2 = $yc + $r1*sin($r1);
      imageline($vImage, $x1, $y1, $x2, $y2, $couleur);
      $x1 = $x2;
      $y1 = $y2;
      $cur++;
    }
    $n++;
  }
}

?>
