#!/bin/bash
METHODE=$1
flag=$TMP_PATH/${METHODE}_bot.flag
date=`date +%Y%m%d0000`

if [ ! -d $APPS_PATH/methode2/$METHODE ];
then
  echo $APPS_PATH/methode2/$METHODE introuvable ...
  exit 1
fi

if [ -f $flag ];
then
  echo "${METHODE}_bot is already running ! [$flag]"
  exit 0
fi

touch $flag

if [ ! -d $DATA_PATH/$METHODE ];
then
  mkdir -p $DATA_PATH/$METHODE
fi

cd $APPS_PATH/methode2

for BLOCK in `awk '{print $2}' $DATA_PATH/block_list.txt`
do
  if [ ! -f $DATA_PATH/$METHODE/$BLOCK.png ]
  then
    php robot.php $1 $BLOCK $((RANDOM % 6)) $2
    if [ "$2" == "" ]; 
    then
      rm -f $DATA_PATH/hasard/$BLOCK.png
      ln $DATA_PATH/last/$BLOCK.png $DATA_PATH/$METHODE/$BLOCK.png
      ln $DATA_PATH/last/$BLOCK.png $DATA_PATH/hasard/$BLOCK.png
    fi
  fi

  if [ -f $DATA_PATH/$METHODE/$BLOCK.png ]
  then
    BNAME=`grep $BLOCK $DATA_PATH/block_list.txt | awk '{print $1}'`
    if [ "$BNAME" == "LAST" ]
    then
      touch $DATA_PATH/$METHODE/$BLOCK.png
    else
      touch -t $date $DATA_PATH/$METHODE/$BLOCK.png
    fi
  fi  
done

rm -f $flag
