<?php

// ---
// --- Par défaut, on trace de lignes
// ---
$methode='line';
if (isset($argv[1])) $methode = $argv[1];

// ---
// --- La config globale
// ---
require_once '../global/inc/config.php';

// ---
// --- External dependances
// ---
require TOPISTO_PATH.'/ressources/vendor/autoload.php';
require_once '../global/inc/colors.php';
require_once '../global/inc/cubic.php';

// ---
// --- Internal dependances
// ---
require_once APP_PATH.'/blockchain/inc/block.php';
require_once $methode.'/draw.php';

// ---
// --- Par défaut on cherche le dernier block
// --- Le cas échéant, on cherche block passé en argument
// ---
$block_hash = 'LAST';
if (isset($argv[2])) $block_hash = $argv[2];

// ---
// --- Par défaut mode 8
// ---
$mode=8;
if (isset($argv[3])) $mode=intval($argv[3]);

// ---
// --- Par défaut taille 1
// ---
$taille=1;
if (isset($argv[4])) $taille=intval($argv[4]);

$the_block = blockchain::getBlockWithHash($block_hash);
if ($the_block === FALSE) die();

$the_name = blockchain::hash2SpecialName($the_block->hash);
if ($the_name == $the_block->hash) $the_name ='';

$bandeau     = 50;
$marge       = 25;
$text_border = 20;
$width       = GRAPH_WIDTH * $taille;
$height      = GRAPH_HEIGHT * $taille;
$couleur     = -1; // Au hasard

// Exception : pour hashes2 on dessine un petit bloc
if ($methode == 'hashes2') $height = 2;

// Exception : pour mondrian on prend unbloc en noir et blanc
if ($methode == 'mondrian') $couleur = 9;

// Pour que l'image simple ait les proportions que l'image full
$width  = $marge + ($width*2)  + (2*$text_border);
$height = $marge + ($height*2);

// création d'une image plus haute pour inclure bandeaux haut et bas
$img_w = $width;
$img_h = $height+(2*$bandeau);
$img = imagecreatetruecolor($img_w, $img_h);

// ---
// --- On dessine les inputs, sauf pour les blocks ne contenanty que la récompense
// ---
$type=2;
if (count($the_block->tx)==1) $type = 4;

$paramHeader = blockchain::DrawBlockHeaderFooter($the_block, $img, $bandeau, $couleur);

imagefilledrectangle($img, 0, $bandeau, $width, $bandeau + $height, $paramHeader[1]);
imageline($img, 0, 5, 0, $img_h-25, $paramHeader[2]);
imageline($img, $width-1, 5, $width-1, $img_h-25, $paramHeader[2]);

$parametres                      = [];
$parametres['x']                 = 0;
$parametres['y']                 = $bandeau;
$parametres['width']             = $width;
$parametres['height']            = $height;
$parametres['methode']           = 5;
$parametres['type']              = $type;
$parametres['iterations']        = 10;
$parametres['transparent_color'] = $paramHeader[0];
$parametres['background_color']  = $paramHeader[1];
$parametres['font_color']        = $paramHeader[2];
$parametres['fontname']          = $paramHeader[3];
$parametres['font_RGB']          = $paramHeader[4];
$parametres['background_RGB']    = $paramHeader[5];

// Une chance sur deux d'inverser entre fg et bg
if (($the_block->nonce%2)==1) {
  $parametres['background_color'] = $paramHeader[2];
  $parametres['background_RGB']   = $paramHeader[4];
  $parametres['font_color']       = $paramHeader[1];
  $parametres['font_RGB']         = $paramHeader[5];
}

DrawBlock($the_block, $img, $parametres);

$imagepath = 'big';
if ($taille == 1) $imagepath = 'last';
imagepng($img, DATA_PATH.'/'.$imagepath.'/'.$the_block->hash.'.png');

imagedestroy($img);

?>
