<?php

use codeagent\treemap\Treemap;
use codeagent\treemap\presenter\ImagePresenter;
use codeagent\treemap\presenter\NodeInfo;

function DrawBlock($the_block, $vImage, $parametres)
{
  $type    = 1;

  if (isset($parametres['x']))                $x       = $parametres['x']+2;
  if (isset($parametres['y']))                $y       = $parametres['y']+2;
  if (isset($parametres['width']))            $width   = $parametres['width']-4;
  if (isset($parametres['height']))           $height  = $parametres['height']-4;
  if (isset($parametres['methode']))          $mode    = $parametres['methode'];
  if (isset($parametres['type']))             $type    = $parametres['type'];
  if (isset($parametres['font_color']))       $vBgColor   = $parametres['font_color'];
  if (isset($parametres['background_color'])) $vFgColor   = $parametres['background_color'];

  imagefilledrectangle($vImage, $x, $y, $x+$width, $y+$height, $vFgColor);

  $couleurs = array();
  $couleurs[0] = imagecolorallocate($vImage, 255, 255, 255);
  $couleurs[1] = imagecolorallocate($vImage, 255, 0, 0);
  $couleurs[2] = imagecolorallocate($vImage, 0, 0, 255);
  $couleurs[3] = imagecolorallocate($vImage, 255, 255, 0);
 
  $full_area = $width * $height;
  if ($full_area == 0) $full_area = 1;

  $data = blockchain::getTransactionData($the_block, $type);

  $treemap = new Treemap($data, $width, $height);
  $map = $treemap->getMap();
  $m = count($map);
  $flag_contour = true;
  for($mm = 0; $mm < $m; $mm++)
  {
    $tx     = $map[$mm];
    $factor = (($tx['_rectangle']->width * $tx['_rectangle']->height) / $full_area)*100.0;

    $x1 = $x + $tx['_rectangle']->left;
    $y1 = $y + $tx['_rectangle']->top;

    $x2 = $x1 + $tx['_rectangle']->width;
    $y2 = $y1 + $tx['_rectangle']->height;

    if ($x1 > ($x+$width))  $x1 = ($x+$width);
    if ($y1 > ($y+$height)) $y1 = ($y+$height);
    if ($x2 > ($x+$width))  $x2 = ($x+$width);
    if ($y2 > ($y+$height)) $y2 = ($y+$height);

    //if (($x2 - $x1) < ($width*0.015)) break;
    //if (($y2 - $y1) < ($height*0.015)) break;

    $factor=$the_block->nonce % 100;
    // Je triche: les petits rectangle sont blancs
    if (($x2 - $x1) < 6) $factor=90;
    if (($y2 - $y1) < 6) $factor=90;

    $couleur = 0;
    if ($factor < 50) $couleur += 1;
    if ($factor < 25) $couleur += 1;
    if ($factor < 10) $couleur += 1;

    // Pourtour noir
    imagefilledrectangle($vImage, $x1, $y1, $x2, $y2, $vBgColor);

    // Intérieur de couleur
    $dx = 1 + floor(0.0025 * $width);
    $dy = 1 + floor(0.0025 * $height);
    // Je triche: les petits rectangle ont un tour de 1 pixel
    if (($x2 - $x1) < 6) $dy=1;
    if (($y2 - $y1) < 6) $dy=1;

    $x1 = $x1 + $dx;$x2 = $x2 - $dx;
    $y1 = $y1 + $dy;$y2 = $y2 - $dy;

    if ($x1 > ($x+$width))  $x1 = ($x+$width);
    if ($y1 > ($y+$height)) $y1 = ($y+$height);
    if ($x2 > ($x+$width))  $x2 = ($x+$width);
    if ($y2 > ($y+$height)) $y2 = ($y+$height);

    imagefilledrectangle($vImage, $x1, $y1, $x2, $y2, $couleurs[$couleur]);
  }
  if ($mm < $m) imagerectangle($vImage, $x1, $y1, $x+$width, $y+$height, $vBgColor);
}

?>
