<?php

function DrawBlock($the_block, $vImage, $parametres)
{
  // valeurs par défaut
  $type   = 1;
  $facteur_max = 2.5;

  // Ces variables vont permettre de caler les lignes
  // dans la zone de dessin en se laissant des marges
  // en haut et en bas
  $somme   = 0;
  $min     =-1;
  $max     = 0;
  $marge_x = 10;
  $marge_y = 10;

  // Détermine si on dessine les tx, les fees ou la récompense
  if (isset($parametres['type']))             $type    = $parametres['type'];

  // Paramètres de dessin
  if (isset($parametres['x']))                $x        = $parametres['x'];
  if (isset($parametres['y']))                $y        = $parametres['y'];
  if (isset($parametres['width']))            $width    = $parametres['width'];
  if (isset($parametres['height']))           $height   = $parametres['height'];
  if (isset($parametres['font_color']))       $vFgColor = $parametres['font_color'];
  if (isset($parametres['background_color'])) $vBgColor = $parametres['background_color'];
  if (isset($parametres['font_RGB']))         $vFgRGB   = $parametres['font_RGB'];
  if (isset($parametres['background_RGB']))   $vBgRGB   = $parametres['background_RGB'];

  // Remplir le fond
  imagefilledrectangle($vImage, $x+($marge_x/2), $y+($marge_y/2), $x+$width-($marge_x/2), $y+$height-($marge_y/2), $vBgColor);

  // Dégradé de 256 couleurs entre la couleur de fond et la couleur de dessin
  $nb_colors = 256;
  $vColor    = array();
  $hex_val   = array(
    ColorGradient::rgb2hex($vFgRGB),
    ColorGradient::rgb2hex($vBgRGB)
  );
  $gradient = ColorGradient::gradient($hex_val[0], $hex_val[1], $nb_colors);
  for($i=0;$i<$nb_colors;$i++)
  {
    $rgbval = ColorGradient::hex2rgb($gradient[$i]);
    $vColor[$i] = new ColorGradient();
    $vColor[$i]->pct   = ($i*1.0) / $nb_colors;
    $vColor[$i]->color = imagecolorallocate($vImage, $rgbval[0], $rgbval[1], $rgbval[2]);
  }

  // Récup des données
  $data = blockchain::getTransactionData($the_block, $type);
  $n_data = count($data);

  // Calcul des min max
  foreach($data as $v)
  {
    if ($v['value'] > $max) $max = $v['value'];
    if (($v['value'] < $min)||($min == -1)) $min = $v['value'];
    $somme += $v['value'];
  }
  if ($min == $max) $max = $min + 1;
  if ($somme == 0) return;

  $coef     = ($height - (2*$marge_y)) / $somme;
  $limite_x = $x + ($width - (2*$marge_x));
  $dx       = round(($width - (2*$marge_x)) / (TX_HASH_LEN));

  $h0 = 0;
  $hauteur = $y + $marge_y;
  $special_draw = (count($data) == 1);

  foreach($data as $transaction)
  {
    //
    // La nouvelle hauteur : cumule des montants de transaction
    //
    $hauteur += $coef * $transaction['value'];

    //
    // Cas des blocks qui n'ont qu'une seule transaction
    //             On se cale au milieu
    // 
    if ($special_draw) $hauteur = $y + ($height / 2);

    //
    // Ne pas tracer 2 lignes à la même hauteur
    //   => c'est possible du fait de l'arrondi
    //      si la transaction a un montant faible
    //
    if ((floor($hauteur)-$h0)<2) continue;
    $h0 = floor($hauteur);
    $facteur = 0.1;

    //
    // On trace
    //
    $x0 = $x + $marge_x;
    for ($i = 0; $i < TX_HASH_LEN; $i++) 
    {
      $y0 = $h0;
      $valeur = hexdec($the_block->hash[$i]);
      if ($valeur != 0) $y0 += floor(($valeur - 8) * $facteur);
      if ($y0 < $y+$marge_y) $y0 = $y+$marge_y;
      if ($y0 > ($y+$height-$marge_y)) $y0 = $y+$height-$marge_y;

      $pct   = (($x0 - $x)*1.0) / ($limite_x - $x);
      $index = floor($pct*$nb_colors);
      imageline($vImage, $x0, $y0, $x0+$dx, $y0, $vColor[$index]->color);
      $x0 += $dx;

      if ($y0 == $h0) continue;

      $facteur = 0.1 + (($facteur_max*$i) / TX_HASH_LEN);
      if ($facteur > $facteur_max) $facteur = $facteur_max;
    }
  }
}

?>
