<?php

function DrawBlock($the_block, $vImage, $parametres)
{
  // valeurs par défaut
  $type   = 1;

  // Ces variables vont permettre de caler les lignes
  // dans la zone de dessin en se laissant des marges
  // en haut et en bas
  $somme   = 0;
  $min     =-1;
  $max     = 0;
  $marge_x = 10;
  $marge_y = 10;

  // Détermine si on dessine les tx, les fees ou la récompense
  if (isset($parametres['type']))             $type    = $parametres['type'];

  // Paramètres de dessin
  if (isset($parametres['x']))                $x        = $parametres['x'];
  if (isset($parametres['y']))                $y        = $parametres['y'];
  if (isset($parametres['width']))            $width    = $parametres['width'];
  if (isset($parametres['height']))           $height   = $parametres['height'];
  if (isset($parametres['font_color']))       $vFgColor = $parametres['font_color'];
  if (isset($parametres['background_color'])) $vBgColor = $parametres['background_color'];

   // Remplir le fond
  imagefilledrectangle($vImage, $x+($marge_x/2), $y+($marge_y/2), $x+$width-($marge_x/2), $y+$height-($marge_y/2), $vBgColor);

  // Récup des données
  $data = blockchain::getTransactionData($the_block, $type);
  $n_data = count($data);

  // Calcul des min max
  foreach($data as $v)
  {
    if ($v['value'] > $max) $max = $v['value'];
    if (($v['value'] < $min)||($min == -1)) $min = $v['value'];
    $somme += $v['value'];
  }
  if ($min == $max) $max = $min + 1;
  if ($somme == 0) return;

  $coef     = ($height - (2*$marge_y)) / $somme;
  $dx       = $width - (2*$marge_x);
  $limite_x = $x + $dx;

  $h0 = 0;
  $hauteur = $y + $marge_y;
  $special_draw = (count($data) == 1);

  foreach($data as $transaction)
  {
    //
    // La nouvelle hauteur : cumule des montants de transaction
    //
    $hauteur += $coef * $transaction['value'];

    //
    // Cas des blocks qui n'ont qu'une seule transaction
    //             On se cale au milieu
    // 
    if ($special_draw) $hauteur = $y + ($height / 2);

    //
    // Ne pas tracer 2 lignes à la même hauteur
    //   => c'est possible du fait de l'arrondi
    //      si la transaction a un montant faible
    //
    if ((floor($hauteur)-$h0)<2) continue;
    $h0 = floor($hauteur);

    //
    // On recommence en début de ligne
    //
    $x0 = $x + $marge_x;

    //
    // La première partie est une ligne droite
    //
    imageline($vImage, $x0, $h0, $x0+$dx, $h0, $vFgColor);
  }
}

?>
