<?php

function DrawBlock($the_block, $vImage, $parametres)
{
  // valeurs par défaut
  $type   = 1;

  // Ces variables vont permettre de caler les lignes
  // dans la zone de dessin en se laissant des marges
  // en haut et en bas
  $somme   = 0;
  $min     =-1;
  $max     = 0;
  $marge_x = 10;
  $marge_y = 10;
  $facteur_max = 2.5;

  // Détermine si on dessine les tx, les fees ou la récompense
  if (isset($parametres['type']))             $type    = $parametres['type'];

  // Paramètres de dessin
  if (isset($parametres['x']))                $x        = $parametres['x'];
  if (isset($parametres['y']))                $y        = $parametres['y'];
  if (isset($parametres['width']))            $width    = $parametres['width'];
  if (isset($parametres['height']))           $height   = $parametres['height'];
  if (isset($parametres['font_color']))       $vFgColor = $parametres['font_color'];
  if (isset($parametres['background_color'])) $vBgColor = $parametres['background_color'];
  if (isset($parametres['font_RGB']))         $vFgRGB   = $parametres['font_RGB'];
  if (isset($parametres['background_RGB']))   $vBgRGB   = $parametres['background_RGB'];

  // Remplir le fond
  imagefilledrectangle($vImage, $x+($marge_x/2), $y+($marge_y/2), $x+$width-+($marge_x/2), $y+$height-+($marge_y/2), $vFgColor);

  // Récup des données
  $data = blockchain::getTransactionData($the_block, $type);
  $n_data = count($data);

  // Plus il y a de transactions plus la couleur de tracé sera transparente
  $alpha = 120;
  $nb = count($data);
  if ($nb < 50) $alpha = 115;
  if ($nb < 20) $alpha = 110;
  if ($nb < 5)  $alpha = 0;
  
  // Dégradé de 360 couleurs entre la couleur de dessin et le blanc
  $vColor = getGDcolorGradientArray($vImage, 360, $vBgRGB, $vBgRGB, $alpha);

  // Un calculateur de Spline
  $oCurve = new CubicSplines();
  $bornes = [[0,180],[180,360]];

  $xc = $x + ($width / 2);
  $yc = $y + ($height / 2);
  $r0 = $width / 3;
  $coef = 0.3;

  foreach($data as $transaction)
  {
    // Un coef aléatoire
    $coef = 0.1;
    $c = rand(0,10);
    if ($c > 5) $coef = 0.3;
    if ($c > 7) $coef = 0.8;
    if ($c > 9) $coef = 1.2;

    foreach($bornes as $b)
    {
      // 1er 1/2 cercle
      $aCoords      = array();
      $x0 = $xc;
      $x1 = $xc;
      for($i=$b[0];$i<$b[1];$i++)
      {
        $valeur = hexdec($transaction['hash'][$i%TX_HASH_LEN]) - 8;
        $r = $r0+($valeur*$coef);
        
        $xi = $xc + $r*cos(deg2rad($i)); 
        $yi = $yc + $r*sin(deg2rad($i));

        $aCoords[$xi] = $yi; 
 
        if ($xi < $x0) $x0 = $xi;
        if ($xi > $x1) $x1 = $xi;
      }
      if ($oCurve) 
      {
        $oCurve->setInitCoords($aCoords);
        $r = $oCurve->processCoords();
        if ($r)
        {
          $curveGraph = new Plot($r);
          $curveGraph->drawLine($vImage, $vColor, $x0, $x1);
        }
      }
    }
  }
}

?>
