<?php

function DrawBlock($the_block, $vImage, $parametres)
{
  // valeurs par défaut
  $type   = 1;

  // Ces variables vont permettre de caler les lignes
  // dans la zone de dessin en se laissant des marges
  // en haut et en bas
  $somme   = 0;
  $min     =-1;
  $max     = 0;
  $marge_x = 10;
  $marge_y = 10;
  $facteur_max = 2.5;
  $alpha   = 0;

  // Détermine si on dessine les tx, les fees ou la récompense
  if (isset($parametres['type']))             $type    = $parametres['type'];

  // Paramètres de dessin
  if (isset($parametres['x']))                $x        = $parametres['x'];
  if (isset($parametres['y']))                $y        = $parametres['y'];
  if (isset($parametres['width']))            $width    = $parametres['width'];
  if (isset($parametres['height']))           $height   = $parametres['height'];
  if (isset($parametres['font_color']))       $vFgColor = $parametres['font_color'];
  if (isset($parametres['background_color'])) $vBgColor = $parametres['background_color'];
  if (isset($parametres['font_RGB']))         $vFgRGB   = $parametres['font_RGB'];
  if (isset($parametres['background_RGB']))   $vBgRGB   = $parametres['background_RGB'];

  // Remplir le fond
  imagefilledrectangle($vImage, $x+($marge_x/2), $y+($marge_y/2), $x+$width-+($marge_x/2), $y+$height-+($marge_y/2), $vFgColor);

  // Dégradé de 360 couleurs entre la couleur de dessin et le blanc
  $vColor = getGDcolorGradientArray($vImage, 360, $vBgRGB, $vBgRGB, $alpha);

  // Récup des données
  $data = blockchain::getTransactionData($the_block, $type);
  $n_data = count($data);

  $xc = $x + ($width / 2);
  $yc = $y + ($height / 2);

  foreach($data as $transaction)
  {
    $r0 = $width/4;
    $x0 = $xc + $r0*cos(deg2rad(0));
    $y0 = $yc + $r0*sin(deg2rad(0));
    for($i=0;$i<TX_HASH_LEN;$i++)
    {
      $valeur = hexdec($transaction['hash'][$i]) - 8;
      $r = $r0+($valeur*rand(0,3));
        
      $xi = floor($xc + $r*cos(deg2rad($i*(360/TX_HASH_LEN)))); 
      $yi = floor($yc + $r*sin(deg2rad($i*(360/TX_HASH_LEN))));

      imageline($vImage, $x0, $y0, $xi, $yi, $vColor[$i]->color);

      $x0 = $xi;
      $y0 = $yi;
    }
    $xi = floor($xc + $r*cos(deg2rad(360))); 
    $yi = floor($yc + $r*sin(deg2rad(360)));
    imageline($vImage, $x0, $y0, $xi, $yi, $vColor[$i]->color);
  }
}

?>
