<?php

function DrawBlock($the_block, $vImage, $parametres)
{
  // valeurs par défaut
  $type   = 1;

  // Ces variables vont permettre de caler les lignes
  // dans la zone de dessin en se laissant des marges
  // en haut et en bas
  $somme   = 0;
  $min     =-1;
  $max     = 0;
  $marge_x = 10;
  $marge_y = 10;
  $facteur_max = 2.5;
  $alpha   = 0;

  // Détermine si on dessine les tx, les fees ou la récompense
  if (isset($parametres['type']))             $type    = $parametres['type'];

  // Paramètres de dessin
  if (isset($parametres['x']))                $x        = $parametres['x'];
  if (isset($parametres['y']))                $y        = $parametres['y'];
  if (isset($parametres['width']))            $width    = $parametres['width'];
  if (isset($parametres['height']))           $height   = $parametres['height'];
  if (isset($parametres['font_color']))       $vFgColor = $parametres['font_color'];
  if (isset($parametres['background_color'])) $vBgColor = $parametres['background_color'];
  if (isset($parametres['font_RGB']))         $vFgRGB   = $parametres['font_RGB'];
  if (isset($parametres['background_RGB']))   $vBgRGB   = $parametres['background_RGB'];

  // Remplir le fond
  imagefilledrectangle($vImage, $x+($marge_x/2), $y+($marge_y/2), $x+$width-+($marge_x/2), $y+$height-+($marge_y/2), $vFgColor);

  // Dégradé de 360 couleurs entre la couleur de dessin et le blanc
  $nbColor = 360;
  $vColor = getGDcolorGradientArray($vImage, $nbColor, $vBgRGB, $vFgRGB, $alpha);

  // Récup des données
  $data = blockchain::getTransactionData($the_block, $type);

  $xc = $x + ($width / 2);
  $yc = $y + ($height / 2);

  foreach($data as $transaction)
  {
    for($i=0;$i<$nbColor;$i++)
    {
      $valeur = hexdec($transaction['hash'][$i%TX_HASH_LEN]);
      if ($valeur != 0) $valeur += $valeur - 8;

      $r = ($width/4)+($valeur*3);
        
      $xi = $xc + $r*cos(deg2rad($i));
      $yi = $yc + $r*sin(deg2rad($i));
      imagesetpixel($vImage, $xi, $yi, $vColor[$i]->color);
    }
  }
}

?>
